global files "C:/Users/WB326023/Dropbox/WB/BPEA/BPEA Replication/"
global BPEAraw "$files/dataraw"
global BPEAout "$files/dataout"
global BPEAtemp "$files/temp"
global BPEAplots "$files/plots"

* colour blind friendly colours
global cblue "0 114 178"
global cred "213 94 0"
global corange "230 159 0"
global cyellow "240 228 66"
global cgreen "0 158 115"
global cblack "0 0 0"
global cpurple "204 121 167"
global cskyblue "86 180 233"

global graphsettings graphregion(color(white)) bgcolor(white) ylabel(, grid glcolor(gs15))


// make figures
// figure 7 - unfriendly, panel A: medical, panel B: other strategic goods
local run = 1
if `run'== 1 {

	// figure 7, panel A 
	use "$BPEAout/us_trade/vf_panel_b_import_unfriendly_q.dta", clear
	keep qdate *630790 *300410 *190110
	gen date_num = qdate
	order qdate date_num
	tsset qdate

	foreach v of varlist share190110 share300410 share630790 { 
		su `v' if qdate == 250 , meanonly 
		local name: variable label `v'
		local call `call' text(`r(mean)' 250 "`name'",  place(r))  	 
	}

	twoway 	(tsline share190110, lcolor("$cblue")) || ///
			(tsline share300410, lcolor("$cgreen")) || ///
			(tsline share630790, lcolor("$cskyblue")), ///
			`call' ///
			$graphsettings /// 
			tlabel(208 "2012q1" 216 "2014q1" ///
				224 "2016q1" 232 "2018q1" ///
				240 "2020q1" 248 "2022q1") ///
			tscale(range(208 256)) ///
			leg(off) ///
			ylab(0(20)100, gmin gmax) ///
			title("Panel A: Medical goods", size(medlarge) color(black)) ///
			xtitle("")
			
	graph save "$BPEAout/us_trade/vf_fig7_panelA_imports_USA_q.gph", replace
	local call 

	// figure 7, panel B 
	use "$BPEAout/us_trade/vf_panel_b_import_unfriendly_q.dta", clear
	keep qdate *270900 *850760 *854231
	gen date_num = qdate
	order qdate date_num
	tsset qdate

	foreach v of varlist share270900 share850760 share854231 { 
		su `v' if qdate == 250 , meanonly 
		local name: variable label `v'
		local call `call' text(`r(mean)' 250 "`name'",  place(r))  	 
	}

	twoway 	(tsline share270900, lcolor("$cred")) || ///
			(tsline share850760, lcolor("$cyellow")) || ///
			(tsline share854231, lcolor("$cpurple")), ///
			`call' ///
			$graphsettings /// 
			tlabel(208 "2012q1" 216 "2014q1" ///
				224 "2016q1" 232 "2018q1" ///
				240 "2020q1" 248 "2022q1") ///
			tscale(range(208 262)) ///
			leg(off) ///
			ylab(0(20)100, gmin gmax) ///
			title("Panel B: Other critical goods", size(medlarge) color(black)) ///
			xtitle("")
			
	graph save "$BPEAout/us_trade/vf_fig7_panelB_imports_USA_q.gph", replace
	local call 

	// combine plots 
	cd "$BPEAout/us_trade"
	local settings xsize(16) ysize(9)  graphregion(color(white)) ///
					title("Percent of U.S. imports from ‘unfriendly’ countries", color(black) size(medium)) ///
					rows(1) ycommon xcommon
					
	graph combine "vf_fig7_panelA_imports_USA_q.gph" "vf_fig7_panelB_imports_USA_q.gph" , `settings'
	
	graph save "$BPEAout/v2_graphs/vf_fig7_landscape.gph", replace
	graph export "$BPEAplots/vf/pdf/vf_fig7_landscape.pdf", replace
	graph export "$BPEAplots/vf/png/vf_fig7_landscape.png",  width(4800) height(2700) replace
	graph export "$BPEAplots/vf/eps/vf_fig7_landscape.eps", replace

}


// figure 8, panel A and B, medical goods and other critical goods
local run = 1
if `run'== 1 {	
    
	// figure 7, panel A - face masks, penicillin, infant formula
	use "$BPEAout/us_trade/vf_panel_a_import_c1c4_q.dta", clear
	keep qdate *630790 *300410 *190110
	gen date_num = qdate
	order qdate date_num
	tsset qdate

	foreach v of varlist c1_190110 c1_300410 c1_630790 { 
		su `v' if qdate == 250 , meanonly 
		local name: variable label `v'
		local call `call' text(`r(mean)' 250 "`name'",  place(r))  	 
	}

	twoway 	(tsline c1_190110, lcolor("$cblue")) || ///
			(tsline c1_300410, lcolor("$cgreen")) || ///
			(tsline c1_630790, lcolor("$cskyblue")), ///
			`call' ///
			$graphsettings /// 
			tlabel(208 "2012q1" 216 "2014q1" ///
				224 "2016q1" 232 "2018q1" ///
				240 "2020q1" 248 "2022q1") ///
			tscale(range(208 256)) ///
			leg(off) ///
			ylab(0(20)100, gmin gmax) ///
			title("Panel A: Medical goods", size(medlarge) color(black)) ///
			xtitle("")
			
	graph save "$BPEAout/us_trade/vf_fig8_panelA_imports_USA_q.gph", replace
	
	local call
	
	
	// figure 8, panel B - crude oil, electric car batteries, semiconductor chips
	use "$BPEAout/us_trade/vf_panel_a_import_c1c4_q.dta", clear
	keep qdate *270900 *850760 *854231
	gen date_num = qdate
	order qdate date_num
	tsset qdate

	foreach v of varlist c1_270900 c1_850760 c1_854231 { 
		su `v' if qdate == 250 , meanonly 
		local name: variable label `v'
		local call `call' text(`r(mean)' 250 "`name'",  place(r))  	 
	}

	twoway 	(tsline c1_270900, lcolor("$cred")) || ///
			(tsline c1_850760, lcolor("$cyellow")) || ///
			(tsline c1_854231, lcolor("$cpurple")), ///
			`call' ///
			$graphsettings /// 
			tlabel(208 "2012q1" 216 "2014q1" ///
				224 "2016q1" 232 "2018q1" ///
				240 "2020q1" 248 "2022q1") ///
			tscale(range(208 262)) ///
			leg(off) ///
			ylab(0(20)100, gmax gmin) ///
			title("Panel B: Other critical goods", size(medlarge) color(black)) ///
			xtitle("")
			
	graph save "$BPEAout/us_trade/vf_fig8_panelB_imports_USA_q.gph", replace

	
	local call

	// combine plots 
	* landscape
	cd "$BPEAout/us_trade"
	local settings xsize(16) ysize(9) graphregion(color(white)) ///
					title("Percent of U.S. imports from country with largest import share", size(medlarge) color(black)) ///
					rows(1) ycommon xcommon
					
	graph combine "vf_fig8_panelA_imports_USA_q.gph" "vf_fig8_panelB_imports_USA_q.gph" , `settings'
	graph save "$BPEAout/v2_graphs/vf_fig8_landscape.gph", replace
	graph export "$BPEAplots/vf/pdf/vf_fig8_landscape.pdf", replace
	graph export "$BPEAplots/vf/png/vf_fig8_landscape.png", width(4800) height(2700) replace
	graph export "$BPEAplots/vf/eps/vf_fig8_landscape.eps", replace

}	
		
	
// Appendix Table A1 data
local run = 1
if `run'== 1 {

	use  "$BPEAout/goods/usa_imports_jan2012_sep2022.dta", clear
	rename partneriso3 countrycode

	gen year = yofd(dofm(date))
	collapse (sum) value, by(reporter countrycode year hs)

	merge m:1 countrycode using "$BPEAtemp/unfriendly_countries.dta", keep(1 3) nogen
	keep reporter countrycode hs year value friendly_sum
	replace friendly_sum=friendly_sum*100
	ren countrycode partner
	egen total_imports = sum(value), by(year hs)
	keep if inlist(hs, "630790", "300410", "300310", "190110", "270900", "850760", "854231")

	gen import_share = (value/total_imports)*100
	keep reporter-friendly_sum import_share
	ren value import_value

	reshape wide import_value import_share, i(reporter partner year friendly_sum) j(hs) string

	sort reporter partner year
	foreach v of varlist *630790 {
		lab var `v' "Face masks"
	}
	foreach v of varlist *300410 {
		lab var `v' "Penicillin"
	}
	foreach v of varlist *300310 {
		lab var `v' "Penicillin"
	}
	foreach v of varlist *190110 {
		lab var `v' "Infant formula"
	}
	foreach v of varlist *270900 {
		lab var `v' "Crude oil"
	}
	foreach v of varlist *850760 {
		lab var `v' "Electric car batteries"
	}
	foreach v of varlist *854231 {
		lab var `v' "Semiconductor chips"
	}

	export excel using "$BPEAplots/vf/datasets/vf_fig67_usa_monthly_trade.xlsx", firstrow(variables) replace
}